//Image Arithmetic- Distance and Connectivity: To understand the notion of connectivity 
//and neighborhood defined for a point in an image.
clc;
clear;
close;
//function to convert gray to binary 
function X = gray2bin(x)
    xmean = mean2(x);
    [m,n]= size(x);
    X = zeros(m,n);
    for i = 1:m
        for j = 1:n
            if x(i,j)> xmean then
                X(i,j) = 1;
            end
        end
    end
endfunction
//function to find total length of two dimensional matrix
function n = numdims(X)
    n = length(size(X));
endfunction
////////////////////////////////////
//Funtion to pad zeros in columns and rows at both ends of an binary image
function B = padarray(b)
    //pad zeros in columns and rows at both ends of an binary image
[m,n] = size(b);
num_dims = length(size(b));
B = zeros(m+num_dims,n+num_dims);
for i = num_dims:m+num_dims-1
    for j = num_dims:m+num_dims-1
        B(i,j) = b(i-1,j-1);
    end
end
endfunction
/////////////////////////////////////
//[1].Euclidean Distance between images and their histograms
I = imread('C:\Users\senthilkumar\Desktop\Chaya_Lab\scilab\lenna.jpg'); 
J = imread('C:\Users\senthilkumar\Desktop\Chaya_Lab\scilab\cameraman.jpeg')
h_I = CreateHistogram(I);//IPD toolbox
h_J = CreateHistogram(J);//IPD toolbox
I = double(I);
J = double(J);
E_dist_Hist = sqrt(sum((h_I-h_J).^2));//Euclidean Distance between histograms of two images
E_dist_images = sqrt(sum((I(:)-J(:)).^2));//Euclidean Distance between two images
disp(E_dist_images,'Euclidean Distance between two images');
disp(E_dist_Hist,'Euclidean Distance between histograms of two images')
//[2]. Connectivity - 8 connected to the background
//exec(gray2bin)
Ibin = gray2bin(I);
Jbin = gray2bin(J);
//conversion of gray image into binary image
conn = [1,1,1;1,1,1;1,1,1];//8-connectivity 
//exec('C:\Users\senthilkumar\Desktop\Gautam_PAL_Lab\numdims.sci')
num_dims = numdims(I);
//exec('C:\Users\senthilkumar\Desktop\Gautam_PAL_Lab\padarray.sci')
B = padarray(Ibin);
global FILTER_ERODE;
StructureElement = CreateStructureElement('square', 3);
B_eroded = MorphologicalFilter(B,FILTER_ERODE,StructureElement.Data);//IPD toolbox
//note:StructureElement.Data and conn both are same values
//except that StructureElement.Data is boolean either true or false
p = B&~B_eroded;
[m,n] = size(p);
for i = num_dims:m+num_dims-2
    for j = num_dims:n+num_dims-2
        pout(i-1,j-1) = p(i,j);
    end
end
figure
ShowImage(uint8(I),'Gray Lenna Image')
figure
ShowImage(Ibin,'Binary Lenna Image')
figure
ShowImage(pout,'8 neighbourhood connectiviy in Lenna Image')
//RESULT
//Euclidean Distance between two images   
// 
//    19797.433  
// 
// Euclidean Distance between histograms of two images   
// 
//    5770.7  
 
